/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import javax.swing.JPanel;

public class WindTest
extends JPanel
implements MouseListener,
MouseMotionListener {
    private LinkedList rects = new LinkedList();
    private SBrect query = new SBrect(0, 0, 0, 0);
    private int mouseX;
    private int mouseY;
    public static LinkedList overlap = new LinkedList();
    private RectTree rt;
    public Random randGen;
    private int qw;
    private int qh;

    public WindTest() {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis();
        this.randGen = new Random(l);
        this.qh = 50;
        this.qw = 50;
    }

    public void generateRects(int n) {
        this.rects.clear();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        for (int i = 0; i < n; ++i) {
            int n4 = 20 + this.randGen.nextInt(100);
            int n5 = 10 + this.randGen.nextInt(50);
            int n6 = this.randGen.nextInt(n2 - n4);
            int n7 = this.randGen.nextInt(n3 - n5);
            this.rects.add(new SBrect(n6, n6 + n4, n7, n7 + n5));
        }
        this.rt = RectTree.constructRectTree(this.rects);
    }

    public void setQuery() {
        this.query.l = (this.getWidth() - this.qw) / 2;
        this.query.b = (this.getHeight() - this.qh) / 2;
        this.query.r = this.query.l + this.qw;
        this.query.t = this.query.b + this.qh;
    }

    public void moveQuery() {
        this.query.l = this.randGen.nextInt(this.getWidth() - this.qw);
        this.query.b = this.randGen.nextInt(this.getHeight() - this.qh);
        this.query.r = this.query.l + this.qw;
        this.query.t = this.query.b + this.qh;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.rects.size() > 2000) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(Color.black);
        Object object = this.rects.listIterator(0);
        while (object.hasNext()) {
            SBrect sBrect = (SBrect)object.next();
            graphics.drawRect(sBrect.l, sBrect.b, sBrect.r - sBrect.l + 1, sBrect.t - sBrect.b + 1);
        }
        graphics.setColor(Color.red);
        if (overlap.size() != 0) {
            ListIterator listIterator = overlap.listIterator(0);
            while (listIterator.hasNext()) {
                object = (SBrect)listIterator.next();
                graphics.drawRect(((SBrect)object).l, ((SBrect)object).b, ((SBrect)object).r - ((SBrect)object).l + 1, ((SBrect)object).t - ((SBrect)object).b + 1);
            }
        }
        graphics.setColor(Color.blue);
        graphics.drawRect(this.query.l, this.query.b, this.query.r - this.query.l + 1, this.query.t - this.query.b + 1);
        graphics.drawRect(this.query.l + 1, this.query.b + 1, this.query.r - this.query.l - 1, this.query.t - this.query.b - 1);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        int n = this.mouseX - (this.query.r + this.query.l) / 2;
        int n2 = this.mouseY - (this.query.b + this.query.t) / 2;
        this.query.l += n;
        this.query.b += n2;
        this.query.r += n;
        this.query.t += n2;
        this.computeOverlap();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        int n = this.mouseX - (this.query.r + this.query.l) / 2;
        int n2 = this.mouseY - (this.query.b + this.query.t) / 2;
        this.query.l += n;
        this.query.b += n2;
        this.query.r += n;
        this.query.t += n2;
        this.computeOverlap();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void computeTrivialOverlap() {
        overlap.clear();
        ListIterator listIterator = this.rects.listIterator(0);
        while (listIterator.hasNext()) {
            SBrect sBrect = (SBrect)listIterator.next();
            if (this.query.r < sBrect.l || this.query.l > sBrect.r || this.query.b > sBrect.t || this.query.t < sBrect.b) continue;
            overlap.add(sBrect);
        }
    }

    public void computeOverlap() {
        overlap.clear();
        RectTree.queryRectTree(this.query, this.rt);
    }
}

