/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Wind
extends JFrame
implements ActionListener {
    private JButton but1;
    private JTextField tf1;
    private WindTest drawPanel;
    private JTextField tf2;
    private JButton but2;
    private JLabel algoTime = new JLabel("");
    private JLabel trivTime = new JLabel("");
    private JLabel overlapCnt = new JLabel("");

    public static void main(String[] stringArray) {
        Wind wind = new Wind();
        wind.setDefaultCloseOperation(3);
    }

    public Wind() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.setSize(3 * n / 4, 3 * n2 / 4);
        this.setLocation(n / 8, n2 / 8);
        this.setTitle("Windowing the rectangles");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.drawPanel = new WindTest();
        this.drawPanel.setBackground(new Color(0xFFFFE0));
        this.drawPanel.addMouseMotionListener(this.drawPanel);
        this.drawPanel.addMouseListener(this.drawPanel);
        container.add((Component)this.drawPanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(0xCCCC99));
        jPanel.setLayout(new GridLayout(10, 1));
        this.tf1 = new JTextField("100");
        this.but1 = new JButton("Generate");
        this.but1.addActionListener(this);
        jPanel.add(new JLabel("# of rects", 0));
        jPanel.add(this.tf1);
        jPanel.add(this.but1);
        this.tf2 = new JTextField("1000");
        this.but2 = new JButton("Benchmark");
        this.but2.addActionListener(this);
        jPanel.add(new JLabel("-----------", 0));
        jPanel.add(new JLabel("# or tests", 0));
        jPanel.add(this.tf2);
        jPanel.add(this.but2);
        jPanel.add(this.algoTime);
        jPanel.add(this.trivTime);
        jPanel.add(this.overlapCnt);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(new Color(0xCCCC99));
        jPanel2.add(jPanel);
        container.add((Component)jPanel2, "East");
        this.setVisible(true);
        this.drawPanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.but1) {
            int n = this.getNumber(this.tf1);
            if (n < 0) {
                return;
            }
            this.drawPanel.generateRects(n);
            this.drawPanel.setQuery();
            this.drawPanel.computeOverlap();
            this.drawPanel.repaint();
        } else if (actionEvent.getSource() == this.but2) {
            int n;
            int n2 = this.getNumber(this.tf1);
            int n3 = this.getNumber(this.tf2);
            if (n2 < 0 || n3 < 0) {
                return;
            }
            this.drawPanel.generateRects(n2);
            this.algoTime.setText("");
            this.trivTime.setText("");
            this.overlapCnt.setText("");
            StopWatch stopWatch = new StopWatch();
            this.drawPanel.randGen.setSeed(1000L);
            stopWatch.start();
            double d = 0.0;
            for (n = 0; n < n3; ++n) {
                this.drawPanel.moveQuery();
                this.drawPanel.computeOverlap();
                d += (double)WindTest.overlap.size();
            }
            stopWatch.stop();
            this.algoTime.setText("Algo: " + 1.0 * (double)stopWatch.getElapsedTime() / (double)n3 + " ms");
            stopWatch.reset();
            this.drawPanel.randGen.setSeed(1000L);
            stopWatch.start();
            for (n = 0; n < n3; ++n) {
                this.drawPanel.moveQuery();
                this.drawPanel.computeTrivialOverlap();
            }
            stopWatch.stop();
            this.trivTime.setText("Triv: " + 1.0 * (double)stopWatch.getElapsedTime() / (double)n3 + " ms");
            this.overlapCnt.setText("Overlap: " + (long)(d / (double)n3));
        }
    }

    public int getNumber(JTextField jTextField) {
        int n = 100;
        try {
            n = Integer.parseInt(jTextField.getText());
            if (n <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Enter a positive integer", "Error message", 0);
            return -1;
        }
        return n;
    }
}

