/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diam
extends JFrame
implements MouseListener {
    LinkedList<Point> points = new LinkedList();
    LinkedList<Point> convHull = new LinkedList();
    Point origin = new Point();
    Point antiPair = new Point(0, 0);

    public static void main(String[] stringArray) {
        Diam diam = new Diam();
        diam.setDefaultCloseOperation(3);
    }

    public Diam() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.setSize(3 * n / 4, 3 * n2 / 4);
        this.setLocation(n / 8, n2 / 8);
        this.setTitle("Diamater of a point set");
        Container container = this.getContentPane();
        container.setBackground(new Color(0xFFFFCC));
        this.addMouseListener(this);
        this.setVisible(true);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.points.add(new Point(mouseEvent.getX(), mouseEvent.getY()));
            this.convHull = this.grahamScan(this.points);
            this.antiPair = this.diam(this.convHull);
            this.repaint();
        } else if (mouseEvent.getButton() == 3) {
            this.points.clear();
            this.convHull.clear();
            this.repaint();
        }
    }

    public LinkedList<Point> grahamScan(LinkedList<Point> linkedList) {
        LinkedList<Point> linkedList2 = new LinkedList<Point>();
        if (linkedList.size() < 3) {
            return linkedList2;
        }
        Point[] pointArray = new Point[linkedList.size()];
        this.origin = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (int i = 0; i < linkedList.size(); ++i) {
            Point point;
            pointArray[i] = point = linkedList.get(i);
            if (point.y >= this.origin.y && (point.y != this.origin.y || point.x >= this.origin.x)) continue;
            this.origin = point;
        }
        this.points.clear();
        Comparator<Point> comparator = new Comparator<Point>(){

            @Override
            public int compare(Point point, Point point2) {
                double d;
                double d2 = Math.atan2(point.y - Diam.this.origin.y, point.x - Diam.this.origin.x);
                if (d2 < (d = Math.atan2(point2.y - Diam.this.origin.y, point2.x - Diam.this.origin.x))) {
                    return -1;
                }
                if (d2 > d) {
                    return 1;
                }
                double d3 = (point.x - Diam.this.origin.x) * (point.x - Diam.this.origin.x) + (point.y - Diam.this.origin.y) * (point.y - Diam.this.origin.y);
                double d4 = (point2.x - Diam.this.origin.x) * (point2.x - Diam.this.origin.x) + (point2.y - Diam.this.origin.y) * (point2.y - Diam.this.origin.y);
                if (d3 < d4) {
                    return -1;
                }
                if (d3 > d4) {
                    return 1;
                }
                return 0;
            }
        };
        Arrays.sort(pointArray, comparator);
        this.points = this.removeDuplicates(pointArray);
        if (this.points.size() < 3) {
            return linkedList2;
        }
        linkedList2.addFirst(this.points.get(0));
        linkedList2.addFirst(this.points.get(1));
        linkedList2.addFirst(this.points.get(2));
        for (int i = 3; i < this.points.size(); ++i) {
            int n;
            Point point = this.points.get(i);
            do {
                Point point2 = linkedList2.getFirst();
                Point point3 = linkedList2.get(1);
                n = (point2.x - point3.x) * (point.y - point3.y) - (point.x - point3.x) * (point2.y - point3.y);
                if (n > 0) continue;
                linkedList2.removeFirst();
            } while (n < 0);
            linkedList2.addFirst(point);
        }
        linkedList2.addFirst(this.origin);
        return linkedList2;
    }

    public Point diam(LinkedList<Point> linkedList) {
        Point point = new Point(0, 0);
        if (linkedList.size() == 2) {
            point.y = 1;
        }
        if (linkedList.size() <= 2) {
            return point;
        }
        linkedList.removeLast();
        Point[] pointArray = linkedList.toArray(new Point[linkedList.size()]);
        System.out.println("\n" + pointArray.length + " points in CH");
        int n = pointArray.length;
        int n2 = n - 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        LinkedList<Point> linkedList2 = new LinkedList<Point>();
        while (this.dist(pointArray[n2], pointArray[n4], pointArray[n5]) > this.dist(pointArray[n2], pointArray[n4], pointArray[n3])) {
            n3 = n5;
            n5 = (n5 + 1) % n;
        }
        int n6 = n3;
        System.out.println("q_0 = " + n6);
        block1: while (n3 != 0) {
            n2 = n4;
            n4 = (n4 + 1) % n;
            linkedList2.add(new Point(n2, n3));
            System.out.println("Line 7: adding (" + n2 + ", " + n3 + ")");
            while (this.dist(pointArray[n2], pointArray[n4], pointArray[n5]) >= this.dist(pointArray[n2], pointArray[n4], pointArray[n3])) {
                n3 = n5;
                n5 = (n5 + 1) % n;
                if (n2 == n6 && n3 == 0) continue block1;
                linkedList2.add(new Point(n2, n3));
                System.out.println("Line 10: adding (" + n2 + ", " + n3 + ")");
            }
        }
        double d = 0.0;
        for (int i = 0; i < linkedList2.size(); ++i) {
            Point point2 = (Point)linkedList2.get(i);
            double d2 = (pointArray[point2.x].x - pointArray[point2.y].x) * (pointArray[point2.x].x - pointArray[point2.y].x) + (pointArray[point2.x].y - pointArray[point2.y].y) * (pointArray[point2.x].y - pointArray[point2.y].y);
            if (!(d2 > d)) continue;
            d = d2;
            point = point2;
        }
        linkedList.add(linkedList.getFirst());
        System.out.println("Diam: (" + point.x + ", " + point.y + ")");
        return point;
    }

    public double dist(Point point, Point point2, Point point3) {
        int n = point2.y - point.y;
        int n2 = point.x - point2.x;
        int n3 = point2.x * point.y - point.x * point2.y;
        int n4 = Math.abs(n * point3.x + n2 * point3.y + n3);
        if (n4 == 0) {
            return 0.0;
        }
        return (double)n4 / Math.sqrt(n * n + n2 * n2);
    }

    @Override
    public void paint(Graphics graphics) {
        Point point;
        super.paint(graphics);
        graphics.setColor(Color.red);
        for (int i = 0; i < this.points.size(); ++i) {
            point = this.points.get(i);
            graphics.fillRect(point.x - 1, point.y - 1, 3, 3);
        }
        if (this.convHull.size() >= 3) {
            graphics.fillOval(this.origin.x - 4, this.origin.y - 4, 8, 8);
            graphics.setColor(Color.blue);
            Point point2 = this.convHull.get(0);
            for (int i = 1; i < this.convHull.size(); ++i) {
                point = this.convHull.get(i);
                graphics.drawLine(point2.x, point2.y, point.x, point.y);
                point2 = point;
            }
            graphics.setColor(Color.green);
            point2 = this.convHull.get(this.antiPair.x);
            point = this.convHull.get(this.antiPair.y);
            graphics.drawLine(point2.x, point2.y, point.x, point.y);
            double d = Math.sqrt((point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y));
            graphics.drawOval((int)Math.round(((double)(point2.x + point.x) - d) / 2.0), (int)Math.round(((double)(point2.y + point.y) - d) / 2.0), (int)Math.round(d), (int)Math.round(d));
        }
    }

    public LinkedList<Point> removeDuplicates(Point[] pointArray) {
        LinkedList<Point> linkedList = new LinkedList<Point>();
        linkedList.addLast(pointArray[0]);
        for (int i = 1; i < pointArray.length; ++i) {
            if (pointArray[i].equals(pointArray[i - 1])) continue;
            linkedList.addLast(pointArray[i]);
        }
        return linkedList;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

