/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JFrame;

public class SimplePoly
extends JFrame
implements MouseListener {
    ArrayList<Point> points = new ArrayList();
    Point[] pointArray;
    Point origin = new Point();

    public static void main(String[] stringArray) {
        SimplePoly simplePoly = new SimplePoly();
        simplePoly.setDefaultCloseOperation(3);
    }

    public SimplePoly() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.setSize(3 * n / 4, 3 * n2 / 4);
        this.setLocation(n / 8, n2 / 8);
        this.setTitle("Simple Polygon");
        Container container = this.getContentPane();
        container.setBackground(new Color(0xFFFFCC));
        this.addMouseListener(this);
        this.setVisible(true);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.points.add(new Point(mouseEvent.getX(), mouseEvent.getY()));
            this.constructPoly();
            this.repaint();
        } else if (mouseEvent.getButton() == 3) {
            this.points.clear();
            this.repaint();
        }
    }

    public void constructPoly() {
        this.pointArray = this.points.toArray(new Point[this.points.size()]);
        if (this.pointArray.length < 3) {
            return;
        }
        this.origin.x = (this.pointArray[0].x + this.pointArray[1].x + this.pointArray[2].x) / 3;
        this.origin.y = (this.pointArray[0].y + this.pointArray[1].y + this.pointArray[2].y) / 3;
        Comparator<Point> comparator = new Comparator<Point>(){

            @Override
            public int compare(Point point, Point point2) {
                double d;
                double d2 = Math.atan2(point.y - SimplePoly.this.origin.y, point.x - SimplePoly.this.origin.x);
                if (d2 < (d = Math.atan2(point2.y - SimplePoly.this.origin.y, point2.x - SimplePoly.this.origin.x))) {
                    return -1;
                }
                if (d2 > d) {
                    return 1;
                }
                double d3 = (point.x - SimplePoly.this.origin.x) * (point.x - SimplePoly.this.origin.x) + (point.y - SimplePoly.this.origin.y) * (point.y - SimplePoly.this.origin.y);
                double d4 = (point2.x - SimplePoly.this.origin.x) * (point2.x - SimplePoly.this.origin.x) + (point2.y - SimplePoly.this.origin.y) * (point2.y - SimplePoly.this.origin.y);
                if (d3 < d4) {
                    return -1;
                }
                if (d3 > d4) {
                    return 1;
                }
                return 0;
            }
        };
        Arrays.sort(this.pointArray, comparator);
    }

    public void paint(Graphics graphics) {
        Point point;
        int n;
        super.paint(graphics);
        graphics.setColor(Color.red);
        if (this.points.size() < 3) {
            for (n = 0; n < this.points.size(); ++n) {
                point = this.points.get(n);
                graphics.fillRect(point.x - 1, point.y - 1, 3, 3);
            }
        } else {
            for (n = 0; n < this.pointArray.length; ++n) {
                point = this.pointArray[n];
                graphics.setColor(Color.red);
                graphics.fillRect(point.x - 1, point.y - 1, 3, 3);
                graphics.setColor(Color.black);
                graphics.drawString(n + 1 + "", point.x + 1, point.y + 1);
            }
        }
        if (this.points.size() >= 3) {
            graphics.fillOval(this.origin.x - 4, this.origin.y - 4, 8, 8);
            graphics.setColor(Color.blue);
            Point point2 = this.pointArray[0];
            for (int i = 1; i < this.pointArray.length; ++i) {
                Point point3 = this.pointArray[i];
                graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
                point2 = point3;
            }
            graphics.drawLine(point2.x, point2.y, this.pointArray[0].x, this.pointArray[0].y);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

