/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrahamScan
extends JFrame
implements MouseListener {
    ArrayList<Point> points = new ArrayList();
    LinkedList<Point> convHull = new LinkedList();
    Point origin = new Point();

    public static void main(String[] stringArray) {
        GrahamScan grahamScan = new GrahamScan();
        grahamScan.setDefaultCloseOperation(3);
    }

    public GrahamScan() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.setSize(3 * n / 4, 3 * n2 / 4);
        this.setLocation(n / 8, n2 / 8);
        this.setTitle("Graham Scan");
        Container container = this.getContentPane();
        container.setBackground(new Color(0xFFFFCC));
        this.addMouseListener(this);
        this.setVisible(true);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.points.add(new Point(mouseEvent.getX(), mouseEvent.getY()));
            this.convHull = this.grahamScan(this.points);
            this.repaint();
        } else if (mouseEvent.getButton() == 3) {
            this.points.clear();
            this.convHull.clear();
            this.repaint();
        }
    }

    public LinkedList<Point> grahamScan(ArrayList<Point> arrayList) {
        LinkedList<Point> linkedList = new LinkedList<Point>();
        if (arrayList.size() < 3) {
            return linkedList;
        }
        Point[] pointArray = new Point[arrayList.size()];
        this.origin = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (int i = 0; i < this.points.size(); ++i) {
            Point point;
            pointArray[i] = point = this.points.get(i);
            if (point.y >= this.origin.y && (point.y != this.origin.y || point.x >= this.origin.x)) continue;
            this.origin = point;
        }
        this.points.clear();
        Comparator<Point> comparator = new Comparator<Point>(){

            @Override
            public int compare(Point point, Point point2) {
                double d;
                double d2 = Math.atan2(point.y - GrahamScan.this.origin.y, point.x - GrahamScan.this.origin.x);
                if (d2 < (d = Math.atan2(point2.y - GrahamScan.this.origin.y, point2.x - GrahamScan.this.origin.x))) {
                    return -1;
                }
                if (d2 > d) {
                    return 1;
                }
                double d3 = (point.x - GrahamScan.this.origin.x) * (point.x - GrahamScan.this.origin.x) + (point.y - GrahamScan.this.origin.y) * (point.y - GrahamScan.this.origin.y);
                double d4 = (point2.x - GrahamScan.this.origin.x) * (point2.x - GrahamScan.this.origin.x) + (point2.y - GrahamScan.this.origin.y) * (point2.y - GrahamScan.this.origin.y);
                if (d3 < d4) {
                    return -1;
                }
                if (d3 > d4) {
                    return 1;
                }
                return 0;
            }
        };
        Arrays.sort(pointArray, comparator);
        this.points = this.removeDuplicates(pointArray);
        if (this.points.size() < 3) {
            return linkedList;
        }
        linkedList.addFirst(this.points.get(0));
        linkedList.addFirst(this.points.get(1));
        linkedList.addFirst(this.points.get(2));
        for (int i = 3; i < this.points.size(); ++i) {
            int n;
            Point point = this.points.get(i);
            do {
                Point point2 = linkedList.getFirst();
                Point point3 = linkedList.get(1);
                n = (point2.x - point3.x) * (point.y - point3.y) - (point.x - point3.x) * (point2.y - point3.y);
                if (n > 0) continue;
                linkedList.removeFirst();
            } while (n < 0);
            linkedList.addFirst(point);
        }
        linkedList.addFirst(this.origin);
        return linkedList;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        for (int i = 0; i < this.points.size(); ++i) {
            graphics.setColor(Color.red);
            Point point = this.points.get(i);
            graphics.fillRect(point.x - 1, point.y - 1, 3, 3);
            graphics.setColor(Color.black);
            graphics.drawString(i + "", point.x + 1, point.y + 1);
        }
        if (this.convHull.size() >= 3) {
            graphics.setColor(Color.red);
            graphics.fillOval(this.origin.x - 4, this.origin.y - 4, 8, 8);
            graphics.setColor(Color.blue);
            Point point = this.convHull.get(0);
            for (int i = 1; i < this.convHull.size(); ++i) {
                Point point2 = this.convHull.get(i);
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                point = point2;
            }
        }
    }

    public ArrayList<Point> removeDuplicates(Point[] pointArray) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(pointArray[0]);
        for (int i = 1; i < pointArray.length; ++i) {
            if (pointArray[i].equals(pointArray[i - 1])) continue;
            arrayList.add(pointArray[i]);
        }
        return arrayList;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

