/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ClosestPair
extends JFrame
implements ActionListener {
    Point[] points;
    Integer[] ptsX;
    int n = 10;
    ClosestPointPair cp;
    LinkedList<Integer> vertLines = new LinkedList();
    JPanel topPanel;
    JPanel drawPanel;
    JTextField textField;
    JCheckBox checkBox;
    JButton button;
    int width;
    int height;
    int shift;

    public static void main(String[] stringArray) {
        ClosestPair closestPair = new ClosestPair();
        closestPair.setDefaultCloseOperation(3);
    }

    public ClosestPair() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.setSize(3 * n / 4, 3 * n2 / 4);
        this.setLocation(n / 8, n2 / 8);
        this.setTitle("Closest Pair of Points");
        this.topPanel = new JPanel();
        this.topPanel.setBackground(Color.orange);
        this.topPanel.setLayout(new FlowLayout());
        this.textField = new JTextField("10", 3);
        this.button = new JButton("Start Over");
        this.topPanel.add(new JLabel("# of points: "));
        this.topPanel.add(this.textField);
        this.topPanel.add(new JLabel("           "));
        this.topPanel.add(this.button);
        this.topPanel.add(new JLabel("           "));
        this.checkBox = new JCheckBox("show lines", true);
        this.checkBox.setBackground(Color.orange);
        this.topPanel.add(this.checkBox);
        this.topPanel.doLayout();
        this.drawPanel = new JPanel();
        this.drawPanel.setBackground(new Color(0xFFFFCC));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.topPanel, "North");
        container.add((Component)this.drawPanel, "Center");
        this.button.addActionListener(this);
        this.textField.addActionListener(this);
        this.checkBox.addActionListener(this);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.button || actionEvent.getSource() == this.textField) {
            this.n = Integer.parseInt(this.textField.getText());
            this.shift = this.topPanel.getHeight();
            this.shift = 70;
            this.height = this.drawPanel.getHeight();
            this.width = this.drawPanel.getWidth();
            this.points = this.generatePoints(this.n, this.width, this.height);
            this.cp = this.computeClosestPair(this.points);
        }
        this.repaint();
    }

    public ClosestPointPair computeClosestPair(Point[] pointArray) {
        this.ptsX = new Integer[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.ptsX[i] = new Integer(i);
        }
        Arrays.sort(this.ptsX, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                int n3 = n;
                int n4 = n2;
                if (ClosestPair.this.points[n3].x == ClosestPair.this.points[n4].x) {
                    return 0;
                }
                if (ClosestPair.this.points[n3].x < ClosestPair.this.points[n4].x) {
                    return -1;
                }
                return 1;
            }
        });
        return this.recursiveClosestPair(0, this.n - 1);
    }

    public ClosestPointPair recursiveClosestPair(int n, int n2) {
        int n3;
        if (n >= n2) {
            return new ClosestPointPair();
        }
        if (n == n2 - 1) {
            double d = this.distance(this.points[n], this.points[n2]);
            return new ClosestPointPair(n, n2, d);
        }
        int n4 = (n + n2) / 2;
        int n5 = this.points[this.ptsX[n4].intValue()].x;
        this.vertLines.add(new Integer(n5));
        ClosestPointPair closestPointPair = this.recursiveClosestPair(n, n4);
        ClosestPointPair closestPointPair2 = this.recursiveClosestPair(n4 + 1, n2);
        ClosestPointPair closestPointPair3 = new ClosestPointPair(closestPointPair);
        if (closestPointPair.d > closestPointPair2.d) {
            closestPointPair3.setPair(closestPointPair2.p, closestPointPair2.q, closestPointPair2.d);
        }
        int[] nArray = new int[this.n];
        int n6 = 0;
        for (n3 = 0; n3 < this.n; ++n3) {
            int n7 = this.points[n3].x;
            if (!((double)n5 - closestPointPair3.d <= (double)n7) || !((double)n7 <= (double)n5 + closestPointPair3.d)) continue;
            nArray[n6++] = n3;
        }
        for (n3 = 0; n3 < n6; ++n3) {
            Point point;
            double d;
            Point point2 = this.points[nArray[n3]];
            for (int i = n3 + 1; i < n6 && (d = this.distance(point2, point = this.points[nArray[i]])) < closestPointPair3.d; ++i) {
                closestPointPair3.setPair(nArray[n3], nArray[i], d);
            }
        }
        return closestPointPair3;
    }

    public double distance(Point point, Point point2) {
        return Math.sqrt((point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y) * (point.y - point2.y));
    }

    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        if (this.points == null) {
            return;
        }
        graphics.setColor(Color.red);
        for (n = 0; n < this.n; ++n) {
            graphics.fillRect(this.points[n].x - 1, this.points[n].y - 1, 3, 3);
        }
        if (this.cp.p >= 0 && this.cp.q >= 0) {
            graphics.setColor(Color.blue);
            graphics.fillRect(this.points[this.cp.p].x - 2, this.points[this.cp.p].y - 2, 5, 5);
            graphics.fillRect(this.points[this.cp.q].x - 2, this.points[this.cp.q].y - 2, 5, 5);
            graphics.drawLine(this.points[this.cp.p].x, this.points[this.cp.p].y, this.points[this.cp.q].x, this.points[this.cp.q].y);
        }
        if (this.checkBox.isSelected()) {
            for (n = 0; n < this.vertLines.size(); ++n) {
                int n2 = this.vertLines.get(n);
                graphics.setColor(Color.green);
                graphics.drawLine(n2, this.shift, n2, this.height + this.shift);
                graphics.setColor(Color.black);
                graphics.drawString(n++ + "", n2, this.shift + 10);
            }
        }
    }

    public Point[] generatePoints(int n, int n2, int n3) {
        int n4;
        this.vertLines.clear();
        Point[] pointArray = new Point[this.n];
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis();
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            n4 = random.nextInt(n2);
            int n5 = random.nextInt(n3) + this.shift;
            pointArray[i] = new Point(n4, n5);
        }
        Arrays.sort(pointArray, new Comparator<Point>(){

            @Override
            public int compare(Point point, Point point2) {
                if (point.x == point2.x && point.y == point2.y) {
                    return 0;
                }
                if (point.y < point2.y || point.y == point2.y && point.x < point2.x) {
                    return -1;
                }
                return 1;
            }
        });
        LinkedList<Point> linkedList = new LinkedList<Point>();
        linkedList.addLast(pointArray[0]);
        for (n4 = 1; n4 < pointArray.length; ++n4) {
            if (pointArray[n4].equals(pointArray[n4 - 1])) continue;
            linkedList.addLast(pointArray[n4]);
        }
        this.n = linkedList.size();
        return linkedList.toArray(new Point[linkedList.size()]);
    }

    class ClosestPointPair {
        double d;
        int p;
        int q;

        public void setPair(int n, int n2, double d) {
            this.p = n;
            this.q = n2;
            this.d = d;
        }

        public ClosestPointPair() {
            this.setPair(-1, -1, Double.MAX_VALUE);
        }

        public ClosestPointPair(int n, int n2, double d) {
            this.setPair(n, n2, d);
        }

        public ClosestPointPair(ClosestPointPair closestPointPair) {
            this.setPair(closestPointPair.p, closestPointPair.q, closestPointPair.d);
        }
    }
}

