/*
 * Decompiled with CFR 0.152.
 */
public class SBTriangle {
    public SBTriangle t1;
    public SBTriangle t2;
    public SBTriangle t3;
    public SBSegment s1;
    public SBSegment s2;
    public SBSegment s3;
    public double radius;
    public int index;

    public SBTriangle(SBSegment sBSegment, SBSegment sBSegment2, SBSegment sBSegment3) {
        this.s1 = sBSegment;
        this.s2 = sBSegment2;
        this.s3 = sBSegment3;
        this.index = -1;
        this.radius = Double.MAX_VALUE;
    }

    public void split3(SBPoint sBPoint) {
        SBSegment sBSegment = new SBSegment(this.getPoint(this.s1), sBPoint);
        SBSegment sBSegment2 = new SBSegment(this.s1.p1, sBPoint);
        SBSegment sBSegment3 = new SBSegment(this.s1.p2, sBPoint);
        SBSegment sBSegment4 = this.getSegment(this.s1, this.s1.p2);
        SBSegment sBSegment5 = this.getSegment(this.s1, this.s1.p1);
        SBTriangle sBTriangle = new SBTriangle(sBSegment5, sBSegment, sBSegment2);
        SBTriangle sBTriangle2 = new SBTriangle(this.s1, sBSegment2, sBSegment3);
        SBTriangle sBTriangle3 = new SBTriangle(sBSegment4, sBSegment, sBSegment3);
        if (sBSegment5.t1 == this) {
            sBSegment5.t1 = sBTriangle;
        } else {
            sBSegment5.t2 = sBTriangle;
        }
        if (this.s1.t1 == this) {
            this.s1.t1 = sBTriangle2;
        } else {
            this.s1.t2 = sBTriangle2;
        }
        if (sBSegment4.t1 == this) {
            sBSegment4.t1 = sBTriangle3;
        } else {
            sBSegment4.t2 = sBTriangle3;
        }
        sBSegment.t1 = sBTriangle;
        sBSegment.t2 = sBTriangle3;
        sBSegment2.t1 = sBTriangle;
        sBSegment2.t2 = sBTriangle2;
        sBSegment3.t1 = sBTriangle2;
        sBSegment3.t2 = sBTriangle3;
        this.t1 = sBTriangle;
        this.t2 = sBTriangle2;
        this.t3 = sBTriangle3;
    }

    public void split2(SBPoint sBPoint, SBSegment sBSegment) {
        SBSegment sBSegment2 = new SBSegment(sBSegment.p1, sBPoint);
        SBSegment sBSegment3 = new SBSegment(sBSegment.p2, sBPoint);
        SBPoint sBPoint2 = this.getPoint(sBSegment);
        SBSegment sBSegment4 = new SBSegment(sBPoint2, sBPoint);
        SBSegment sBSegment5 = this.getSegment(sBSegment, sBSegment.p1);
        SBSegment sBSegment6 = this.getSegment(sBSegment, sBSegment.p2);
        SBTriangle sBTriangle = new SBTriangle(sBSegment2, sBSegment4, sBSegment5);
        SBTriangle sBTriangle2 = new SBTriangle(sBSegment3, sBSegment4, sBSegment6);
        sBSegment4.t1 = sBTriangle;
        sBSegment4.t2 = sBTriangle2;
        if (sBSegment5.t1 == this) {
            sBSegment5.t1 = sBTriangle;
        } else {
            sBSegment5.t2 = sBTriangle;
        }
        if (sBSegment6.t1 == this) {
            sBSegment6.t1 = sBTriangle2;
        } else {
            sBSegment6.t2 = sBTriangle2;
        }
        this.t1 = sBTriangle;
        this.t2 = sBTriangle2;
        this.t3 = null;
    }

    public void flipEdge(SBPoint sBPoint, SBSegment sBSegment, SBTriangle sBTriangle) {
        SBSegment sBSegment2 = new SBSegment(sBPoint, sBTriangle.getPoint(sBSegment));
        SBSegment sBSegment3 = this.getSegment(sBSegment, sBSegment.p1);
        SBSegment sBSegment4 = this.getSegment(sBSegment, sBSegment.p2);
        SBSegment sBSegment5 = sBTriangle.getSegment(sBSegment, sBSegment.p1);
        SBSegment sBSegment6 = sBTriangle.getSegment(sBSegment, sBSegment.p2);
        SBTriangle sBTriangle2 = new SBTriangle(sBSegment3, sBSegment5, sBSegment2);
        SBTriangle sBTriangle3 = new SBTriangle(sBSegment4, sBSegment6, sBSegment2);
        sBSegment2.t1 = sBTriangle2;
        sBSegment2.t2 = sBTriangle3;
        if (sBSegment3.t1 == this) {
            sBSegment3.t1 = sBTriangle2;
        } else {
            sBSegment3.t2 = sBTriangle2;
        }
        if (sBSegment4.t1 == this) {
            sBSegment4.t1 = sBTriangle3;
        } else {
            sBSegment4.t2 = sBTriangle3;
        }
        if (sBSegment5.t1 == sBTriangle) {
            sBSegment5.t1 = sBTriangle2;
        } else {
            sBSegment5.t2 = sBTriangle2;
        }
        if (sBSegment6.t1 == sBTriangle) {
            sBSegment6.t1 = sBTriangle3;
        } else {
            sBSegment6.t2 = sBTriangle3;
        }
        this.t1 = sBTriangle2;
        this.t2 = sBTriangle3;
        sBTriangle.t1 = sBTriangle2;
        sBTriangle.t2 = sBTriangle3;
    }

    public SBPoint getPoint(SBSegment sBSegment) {
        SBSegment sBSegment2 = this.s1 == sBSegment ? this.s2 : this.s1;
        return sBSegment2.p1 == sBSegment.p1 || sBSegment2.p1 == sBSegment.p2 ? sBSegment2.p2 : sBSegment2.p1;
    }

    public SBSegment getSegment(SBSegment sBSegment, SBPoint sBPoint) {
        if (sBSegment == this.s1) {
            return this.s2.p1 == sBPoint || this.s2.p2 == sBPoint ? this.s2 : this.s3;
        }
        if (sBSegment == this.s2) {
            return this.s1.p1 == sBPoint || this.s1.p2 == sBPoint ? this.s1 : this.s3;
        }
        return this.s1.p1 == sBPoint || this.s1.p2 == sBPoint ? this.s1 : this.s2;
    }

    private boolean sameSide(SBPoint sBPoint, SBSegment sBSegment) {
        SBPoint sBPoint2 = this.getPoint(sBSegment);
        double d = (sBPoint.x - sBSegment.p2.x) * (sBSegment.p1.y - sBSegment.p2.y) - (sBPoint.y - sBSegment.p2.y) * (sBSegment.p1.x - sBSegment.p2.x);
        double d2 = (sBPoint2.x - sBSegment.p2.x) * (sBSegment.p1.y - sBSegment.p2.y) - (sBPoint2.y - sBSegment.p2.y) * (sBSegment.p1.x - sBSegment.p2.x);
        return d * d2 >= 0.0;
    }

    public boolean contains(SBPoint sBPoint) {
        return this.sameSide(sBPoint, this.s1) && this.sameSide(sBPoint, this.s2) && this.sameSide(sBPoint, this.s3);
    }

    public SBSegment hasOnSide(SBPoint sBPoint) {
        if (sBPoint.isOnSegment(this.s1)) {
            return this.s1;
        }
        if (sBPoint.isOnSegment(this.s2)) {
            return this.s2;
        }
        if (sBPoint.isOnSegment(this.s3)) {
            return this.s3;
        }
        return null;
    }

    public void computeRadius() {
        SBPoint sBPoint = this.s1.p1;
        SBPoint sBPoint2 = this.s1.p2;
        SBPoint sBPoint3 = this.getPoint(this.s1);
        double d = sBPoint2.x * sBPoint2.x + sBPoint2.y * sBPoint2.y;
        double d2 = (sBPoint.x * sBPoint.x + sBPoint.y * sBPoint.y - d) / 2.0;
        double d3 = (d - sBPoint3.x * sBPoint3.x - sBPoint3.y * sBPoint3.y) / 2.0;
        double d4 = (sBPoint.x - sBPoint2.x) * (sBPoint2.y - sBPoint3.y) - (sBPoint2.x - sBPoint3.x) * (sBPoint.y - sBPoint2.y);
        if (Math.abs(d4) < 1.0E-14) {
            this.radius = Double.MAX_VALUE;
        } else {
            double d5 = (d2 * (sBPoint2.y - sBPoint3.y) - d3 * (sBPoint.y - sBPoint2.y)) / d4;
            double d6 = ((sBPoint.x - sBPoint2.x) * d3 - (sBPoint2.x - sBPoint3.x) * d2) / d4;
            this.radius = Math.sqrt((d5 - sBPoint.x) * (d5 - sBPoint.x) + (d6 - sBPoint.y) * (d6 - sBPoint.y));
        }
    }

    public String toString() {
        return this.s1.p1.toString() + " " + this.s1.p2.toString() + " " + this.getPoint(this.s1).toString();
    }
}

