/*
 * Decompiled with CFR 0.152.
 */
public class SBSegment {
    public SBPoint p1;
    public SBPoint p2;
    public SBTriangle t1;
    public SBTriangle t2;
    public double aMin;
    public double aMax;
    public int index;

    public SBSegment(SBPoint sBPoint, SBPoint sBPoint2) {
        this.p1 = sBPoint;
        this.p2 = sBPoint2;
    }

    public int isIllegal(int n, SBPoint sBPoint, SBTriangle sBTriangle) {
        if (this.p1.index >= n && this.p2.index >= n) {
            return 1;
        }
        SBPoint sBPoint2 = sBTriangle.getPoint(this);
        if (!SBSegment.intersect(this.p1, this.p2, sBPoint, sBPoint2)) {
            return 2;
        }
        if (this.p1.index < n && this.p2.index < n && sBPoint.index < n && sBPoint2.index < n) {
            if (sBPoint2.inCircle(sBPoint, this.p1, this.p2)) {
                return 0;
            }
            return 3;
        }
        if ((this.p1.index >= n || this.p2.index >= n) && sBPoint.index < n && sBPoint2.index < n) {
            return 0;
        }
        if (this.p1.index < n && this.p2.index < n && (sBPoint.index < n && sBPoint2.index >= n || sBPoint.index >= n && sBPoint2.index < n)) {
            return 4;
        }
        int n2 = Math.max(this.p1.index, this.p2.index);
        int n3 = Math.max(sBPoint.index, sBPoint2.index);
        if (n2 >= n && n3 >= n) {
            if (n2 > n3) {
                return 0;
            }
            return 5;
        }
        return 6;
    }

    public static boolean intersect(SBPoint sBPoint, SBPoint sBPoint2, SBPoint sBPoint3, SBPoint sBPoint4) {
        double d = sBPoint.x;
        double d2 = sBPoint2.x;
        double d3 = sBPoint3.y;
        double d4 = sBPoint4.y;
        double d5 = sBPoint.y;
        double d6 = sBPoint2.y;
        double d7 = sBPoint3.x;
        double d8 = sBPoint4.x;
        double d9 = (d - d2) * (d3 - d4) - (d5 - d6) * (d7 - d8);
        if (d9 == 0.0) {
            return false;
        }
        double d10 = ((d7 - d8) * (d * d6 - d5 * d2) - (d - d2) * (d7 * d4 - d3 * d8)) / d9;
        double d11 = ((d3 - d4) * (d * d6 - d5 * d2) - (d5 - d6) * (d7 * d4 - d3 * d8)) / d9;
        if (d10 < Math.min(d, d2) || d10 > Math.max(d, d2)) {
            return false;
        }
        if (d10 < Math.min(d7, d8) || d10 > Math.max(d7, d8)) {
            return false;
        }
        if (d11 < Math.min(d5, d6) || d11 > Math.max(d5, d6)) {
            return false;
        }
        return !(d11 < Math.min(d3, d4)) && !(d11 > Math.max(d3, d4));
    }

    public void computeAlphaValue() {
        if (this.t1 != null && this.t2 != null) {
            this.aMin = Math.min(this.t1.radius, this.t2.radius);
            this.aMax = Math.max(this.t1.radius, this.t2.radius);
        } else {
            SBTriangle sBTriangle = this.t1 == null ? this.t2 : this.t1;
            this.aMin = sBTriangle.radius;
            this.aMax = Double.MAX_VALUE;
        }
    }

    public String toString() {
        int n = (int)Math.round(this.p1.x);
        int n2 = (int)Math.round(this.p1.y);
        int n3 = (int)Math.round(this.p2.x);
        int n4 = (int)Math.round(this.p2.y);
        return "(" + n + "," + n2 + ") (" + n3 + "," + n4 + ")";
    }
}

