/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;

public class AlphaShapeTest3
extends JPanel {
    public SBPoint[] points;
    public boolean ready = false;
    public boolean ready2 = false;
    private SBTriangle T;
    public int pointsNo;
    private ArrayList<SBTriangle> triangles = new ArrayList();
    private ArrayList<SBSegment> edges = new ArrayList();
    public double[] alphas;
    public double alpha = Double.MAX_VALUE;
    public double maxAlpha = 0.0;
    public double minAlpha = Double.MAX_VALUE;
    public SBPoint fp1;
    public SBPoint fp2;
    public SBPoint fp3;

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        Object object;
        int n3;
        super.paintComponent(graphics);
        this.setBackground(new Color(0xFFFFE0));
        if (this.pointsNo > 0) {
            graphics.setColor(Color.red);
            for (n3 = 0; n3 < this.pointsNo; ++n3) {
                object = this.points[n3];
                n2 = (int)Math.round(((SBPoint)object).x);
                n = (int)Math.round(((SBPoint)object).y);
                graphics.fillRect(n2 - 1, n - 1, 3, 3);
            }
        }
        if (this.ready2 && this.pointsNo > 0) {
            for (n3 = 0; n3 < this.edges.size(); ++n3) {
                object = this.edges.get(n3);
                if (!(((SBSegment)object).aMin <= this.alpha)) continue;
                n2 = (int)(((SBSegment)object).p1.x + 0.5);
                n = (int)(((SBSegment)object).p1.y + 0.5);
                int n4 = (int)(((SBSegment)object).p2.x + 0.5);
                int n5 = (int)(((SBSegment)object).p2.y + 0.5);
                if (((SBSegment)object).aMax <= this.alpha) {
                    graphics.setColor(Color.gray);
                } else {
                    graphics.setColor(Color.blue);
                }
                graphics.drawLine(n2, n, n4, n5);
            }
        }
    }

    public void drawCircle(Graphics graphics, SBPoint sBPoint, SBPoint sBPoint2, SBPoint sBPoint3) {
        double d = sBPoint2.x * sBPoint2.x + sBPoint2.y * sBPoint2.y;
        double d2 = (sBPoint.x * sBPoint.x + sBPoint.y * sBPoint.y - d) / 2.0;
        double d3 = (d - sBPoint3.x * sBPoint3.x - sBPoint3.y * sBPoint3.y) / 2.0;
        double d4 = (sBPoint.x - sBPoint2.x) * (sBPoint2.y - sBPoint3.y) - (sBPoint2.x - sBPoint3.x) * (sBPoint.y - sBPoint2.y);
        if (Math.abs(d4) < 1.0E-14) {
            return;
        }
        int n = (int)Math.round((d2 * (sBPoint2.y - sBPoint3.y) - d3 * (sBPoint.y - sBPoint2.y)) / d4);
        int n2 = (int)Math.round(((sBPoint.x - sBPoint2.x) * d3 - (sBPoint2.x - sBPoint3.x) * d2) / d4);
        int n3 = (int)Math.round(Math.sqrt(((double)n - sBPoint.x) * ((double)n - sBPoint.x) + ((double)n2 - sBPoint.y) * ((double)n2 - sBPoint.y)));
        graphics.drawOval(n - n3, n2 - n3, 2 * n3, 2 * n3);
    }

    public void computeDeloneTriangulation() {
        Object object;
        for (int i = 0; i < this.pointsNo; ++i) {
            this.points[i].x += Math.random() / 10.0;
            this.points[i].y += Math.random() / 10.0;
            int n = (int)(Math.random() * (double)(this.pointsNo - i)) + i;
            object = this.points[i];
            int n2 = ((SBPoint)object).index;
            this.points[i] = this.points[n];
            int n3 = this.points[n].index;
            this.points[n] = object;
            this.points[i].index = n3;
            this.points[n].index = n2;
        }
        double d = Math.max(this.getWidth(), this.getHeight());
        this.fp1 = new SBPoint(3.0 * d, 0.0, this.pointsNo);
        this.fp2 = new SBPoint(0.0, 3.0 * d, this.pointsNo + 1);
        this.fp3 = new SBPoint(-3.0 * d, -3.0 * d, this.pointsNo + 2);
        this.points[this.pointsNo] = this.fp1;
        this.points[this.pointsNo + 1] = this.fp2;
        this.points[this.pointsNo + 2] = this.fp3;
        object = new SBSegment(this.fp1, this.fp2);
        SBSegment sBSegment = new SBSegment(this.fp1, this.fp3);
        SBSegment sBSegment2 = new SBSegment(this.fp2, this.fp3);
        sBSegment.t1 = sBSegment2.t1 = (this.T = new SBTriangle((SBSegment)object, sBSegment, sBSegment2));
        ((SBSegment)object).t1 = sBSegment2.t1;
        sBSegment2.t2 = null;
        sBSegment.t2 = null;
        ((SBSegment)object).t2 = null;
        for (int i = 0; i < this.pointsNo; ++i) {
            this.updateDeloneTriangulation(i);
        }
        this.triangles.clear();
        this.computeRadii(this.T);
        this.edges.clear();
        this.computeAlphaValues();
        this.alpha = this.maxAlpha;
        this.ready2 = true;
    }

    public void updateDeloneTriangulation(int n) {
        SBPoint sBPoint = this.points[n];
        System.out.println("adding point " + n);
        SBTriangle sBTriangle = this.findTriangle(this.T, sBPoint);
        if (sBTriangle != null) {
            SBSegment sBSegment = sBTriangle.hasOnSide(sBPoint);
            if (sBSegment == null) {
                sBTriangle.split3(sBPoint);
                this.legalizeEdge(sBPoint, sBTriangle.s1);
                this.legalizeEdge(sBPoint, sBTriangle.s2);
                this.legalizeEdge(sBPoint, sBTriangle.s3);
            } else {
                SBTriangle sBTriangle2;
                sBTriangle.split2(sBPoint, sBSegment);
                this.legalizeEdge(sBPoint, sBTriangle.getSegment(sBSegment, sBSegment.p1));
                this.legalizeEdge(sBPoint, sBTriangle.getSegment(sBSegment, sBSegment.p2));
                SBTriangle sBTriangle3 = sBTriangle2 = sBSegment.t1 == sBTriangle ? sBSegment.t2 : sBSegment.t1;
                if (sBTriangle2 != null) {
                    this.legalizeEdge(sBPoint, sBTriangle2.getSegment(sBSegment, sBSegment.p1));
                    this.legalizeEdge(sBPoint, sBTriangle2.getSegment(sBSegment, sBSegment.p2));
                }
            }
        }
    }

    private SBTriangle findTriangle(SBTriangle sBTriangle, SBPoint sBPoint) {
        if (sBTriangle == null) {
            return null;
        }
        if (sBTriangle.index == sBPoint.index) {
            return null;
        }
        if (sBTriangle.t1 == null) {
            if (sBTriangle.contains(sBPoint)) {
                return sBTriangle;
            }
            return null;
        }
        sBTriangle.index = sBPoint.index;
        SBTriangle sBTriangle2 = this.findTriangle(sBTriangle.t1, sBPoint);
        if (sBTriangle2 == null && (sBTriangle2 = this.findTriangle(sBTriangle.t2, sBPoint)) == null) {
            sBTriangle2 = this.findTriangle(sBTriangle.t3, sBPoint);
        }
        return sBTriangle2;
    }

    private void legalizeEdge(SBPoint sBPoint, SBSegment sBSegment) {
        SBTriangle sBTriangle;
        SBTriangle sBTriangle2 = sBSegment.t1.getPoint(sBSegment) == sBPoint ? sBSegment.t1 : sBSegment.t2;
        SBTriangle sBTriangle3 = sBTriangle = sBSegment.t1 == sBTriangle2 ? sBSegment.t2 : sBSegment.t1;
        if (sBSegment.isIllegal(this.pointsNo, sBPoint, sBTriangle) == 0) {
            sBTriangle2.flipEdge(sBPoint, sBSegment, sBTriangle);
            SBSegment sBSegment2 = sBTriangle.getSegment(sBSegment, sBSegment.p1);
            SBSegment sBSegment3 = sBTriangle.getSegment(sBSegment, sBSegment.p2);
            this.legalizeEdge(sBPoint, sBSegment2);
            this.legalizeEdge(sBPoint, sBSegment3);
        }
    }

    private void computeRadii(SBTriangle sBTriangle) {
        if (sBTriangle == null) {
            return;
        }
        if (sBTriangle.index == this.pointsNo) {
            return;
        }
        if (sBTriangle.t1 == null) {
            if (sBTriangle.s1.p1.index < this.pointsNo && sBTriangle.s1.p2.index < this.pointsNo && sBTriangle.getPoint((SBSegment)sBTriangle.s1).index < this.pointsNo) {
                sBTriangle.computeRadius();
                sBTriangle.index = this.pointsNo;
                this.triangles.add(sBTriangle);
            }
            return;
        }
        this.computeRadii(sBTriangle.t1);
        if (sBTriangle.t2 != null) {
            this.computeRadii(sBTriangle.t2);
        }
        if (sBTriangle.t3 != null) {
            this.computeRadii(sBTriangle.t3);
        }
        sBTriangle.index = this.pointsNo;
    }

    private void computeAlphaValues() {
        int n;
        this.maxAlpha = 0.0;
        this.minAlpha = Double.MAX_VALUE;
        for (n = 0; n < this.triangles.size(); ++n) {
            SBTriangle sBTriangle = this.triangles.get(n);
            this.processEdge(sBTriangle.s1);
            this.processEdge(sBTriangle.s2);
            this.processEdge(sBTriangle.s3);
        }
        this.alphas = new double[this.edges.size()];
        for (n = 0; n < this.alphas.length; ++n) {
            this.alphas[n] = this.edges.get((int)n).aMin;
        }
        Arrays.sort(this.alphas);
    }

    private void processEdge(SBSegment sBSegment) {
        if (sBSegment.index != this.pointsNo) {
            sBSegment.computeAlphaValue();
            if (sBSegment.aMin > this.maxAlpha) {
                this.maxAlpha = sBSegment.aMin;
            }
            if (sBSegment.aMin < this.minAlpha) {
                this.minAlpha = sBSegment.aMin;
            }
            sBSegment.index = this.pointsNo;
            this.edges.add(sBSegment);
        }
    }
}

